#!/bin/sh

MASTER_PAGE_MS_NEW_PASSWORD_RESULT_MSG=""
MASTER_PAGE_MS_NEW_PASSWORD_RESULT_OK=0
MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ERROR=1

MASTER_PAGE_MS_NEW_PASSWORD_RESULT_CODE=${MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ERROR}
MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ROLLING=0

master_page_ms_new_password() {
	#debug_print "${0}" "${LINENO}" 'in function "master_page_ms_change_password" account:$1'
	local form_data="\"$MASTER_PAGE_MS_NEW_PASSWORD_PASSWORD\"  1 1 \"\" 1 19 64 0 1\
					 \"$MASTER_PAGE_MS_NEW_PASSWORD_RETYPE_PASSWORD\"  2 1 \"\" 2 19 64 0 1"
	local form_height=2
	
	tp_mixedform \
	"${MASTER_PAGE_MS_NEW_PASSWORD_TITLE}" \
	"${MASTER_PAGE_MS_NEW_PASSWORD_TEXT}" \
	"${MASTER_PAGE_MS_NEW_PASSWORD_LABEL_OK}" \
	"${MASTER_PAGE_MS_NEW_PASSWORD_LABEL_CANCEL}" \
	"$form_data" \
	$form_height
	
	# no error cases
	MASTER_PAGE_MS_NEW_PASSWORD_RESULT_CODE=${MASTER_PAGE_MS_NEW_PASSWORD_RESULT_OK}

	if [ "${TP_MIXEDFORM_RESULT_CODE}" == "${TP_MIXEDFORM_RESULT_CANCEL}" ]; then
		MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ROLLING=-1
		return
	fi

	local password1=`echo "${TP_MIXEDFORM_RESULT_DATA}" | sed -n '1p'`
	local password2=`echo "${TP_MIXEDFORM_RESULT_DATA}" | sed -n '2p'`

    if [ "${password1}" == "" ] ; then
        dprint "ERROR" "${TP_USERNAME_PASSWORD_ERROR_INVALID_PASSWORD}" 
        warning_with_title "${MASTER_PAGE_MS_NEW_PASSWORD_TITLE}" "${TP_USERNAME_PASSWORD_ERROR_INVALID_PASSWORD}"
        MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ROLLING=0
        return
    fi

	# account_to_be_modified defined in master_page_accounts_mngt.sh
        #account_to_be_modified="admin"
	if [ "${password1}" == "${password2}" ]; then
		local ret=`cat /etc/passwd | awk '{FS=":"} {print $1}' | grep "^${account_to_be_modified}$"`
		if [ "${ret}" == "" ]; then
			# add a user with group "tui"
                        dprint "DEBUG" "Add user:$account_to_be_modified"
			/usr/sbin/useradd "$account_to_be_modified" 2>&1 > /dev/null
                        ret=${?}
                        if [ "${ret}" != "0" ]; then
                            MASTER_PAGE_MS_NEW_PASSWORD_RESULT_CODE=${MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ERROR}
                            MASTER_PAGE_MS_NEW_PASSWORD_RESULT_MSG="${TP_USERNAME_PASSWORD_ERROR_INVALID_USERNAME}"
                            MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ROLLING=-1
                            return
                        fi
			chsh -s /opt/TrendMicro/Pixiebob/textUI/admin_shell "$account_to_be_modified" 2>&1 > /dev/null
			ret=${?}
                        if [ "${ret}" != "0" ]; then
                            dprint "ERROR" "Fail to add user, delete it."
                            /usr/sbin/userdel "$account_to_be_modified" 2>&1 > /dev/null
                            MASTER_PAGE_MS_NEW_PASSWORD_RESULT_CODE=${MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ERROR}
                            MASTER_PAGE_MS_NEW_PASSWORD_RESULT_MSG="${TP_USERNAME_PASSWORD_ERROR_INVALID_USERNAME}"
                            MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ROLLING=-1
                            return
                        fi
                else
                        dprint "DEBUG" "Change password for user:$account_to_be_modified"
		fi

        echo "$password1" | passwd "$account_to_be_modified" --stdin 2>&1 > /dev/null
		MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ROLLING=1
        #save audit log
        #save_audit_log "all.systemEvents.textui.passwordChange"
        
    else
        dprint "ERROR" "${MASTER_PAGE_MS_NEW_PASSWORD_DO_NOT_MATCH}"
        warning_with_title "${MASTER_PAGE_MS_NEW_PASSWORD_TITLE}" "${MASTER_PAGE_MS_NEW_PASSWORD_DO_NOT_MATCH}"
		MASTER_PAGE_MS_NEW_PASSWORD_RESULT_ROLLING=0
    fi
}
